<?php
/**
 * Plugin Name: TAP - Custom Functions
 * Description: Custom functionality written to be used by the Esoteric website.
 * Version: 1.0
 * Author: The Affari Project
 * Author URI: http://affariproject.com
 */


// Add ACF options page
acf_add_options_page();

// Register Custom Post Type
function custom_post_type() {

	$labels = array(
		'name'                => 'Gallery',
		'singular_name'       => 'Image',
		'menu_name'           => 'Gallery',
		'name_admin_bar'      => 'Gallery',
		'parent_item_colon'   => 'Parent Gallery:',
		'all_items'           => 'All Images',
		'add_new_item'        => 'Add New Image',
		'add_new'             => 'Add New',
		'new_item'            => 'New Image',
		'edit_item'           => 'Edit Image',
		'update_item'         => 'Update Image',
		'view_item'           => 'View Image',
		'search_items'        => 'Search for Image',
		'not_found'           => 'Not found',
		'not_found_in_trash'  => 'Not found in Trash',
	);
	$args = array(
		'label'               => 'gallery',
		'description'         => 'Gallery',
		'labels'              => $labels,
		'supports'            => array( 'title', 'category' ),
		'hierarchical'        => false,
		'public'              => true,
		'show_ui'             => true,
		'show_in_menu'        => true,
		'menu_position'       => 25,
		'menu_icon'           => 'dashicons-grid-view',
		'show_in_admin_bar'   => false,
		'show_in_nav_menus'   => false,
		'can_export'          => true,
		'has_archive'         => true,
		'exclude_from_search' => true,
		'publicly_queryable'  => true,
		'taxonomies'          => array( 'gcategory' ),
		'capability_type'     => 'page',
		'rewrite' => array( 'slug' => 'gallery' ),
	);
	register_post_type( 'gallery_cpt', $args );

	// $args = array('hierarchical' => true,);
	// register_taxonomy( 'gcategory', array( 'gallery_cpt'), $args );

}


//hook into the init action and call create_book_taxonomies when it fires

//create a custom taxonomy name it topics for your posts

function create_tax() {

	$labels = array(
		'name' => _x( 'Categories', 'taxonomy general name' ),
		'singular_name' => _x( 'Categories', 'taxonomy singular name' ),
		'search_items' =>  __( 'Search Categories' ),
		'all_items' => __( 'All Categories' ),
		'parent_item' => __( 'Parent Category' ),
		'parent_item_colon' => __( 'Parent Category:' ),
		'edit_item' => __( 'Edit Category' ), 
		'update_item' => __( 'Update Category' ),
		'add_new_item' => __( 'Add New Category' ),
		'new_item_name' => __( 'New Category Name' ),
		'menu_name' => __( 'Categories' ),
	); 	

	register_taxonomy('gcategory',array('gallery_cpt'), array(
		'hierarchical' => true,
		'labels' => $labels,
		'show_ui' => true,
		'show_admin_column' => true,
		'query_var' => true,
		'rewrite' => array( 'slug' => 'gallery' ),
	));

}


// Hook into the 'init' action
add_action( 'init', 'create_tax', 0 );
add_action( 'init', 'custom_post_type', 0 );


// Removing emojis
remove_action( 'wp_head', 'print_emoji_detection_script', 7 );
remove_action( 'wp_print_styles', 'print_emoji_styles' );

?>