<?php get_header(); ?>

<?php
	$i = 1;
	//$paged is for setting up pagination for wp_query
	$paged = ( get_query_var('paged') ) ? get_query_var('paged') : 1;

	//if page is taxonomy gcategory, then add taxonomy to the query.
	if( is_tax('gcategory') ) {
		$current_tax = get_query_var($wp_query->query_vars['taxonomy']);
		$tax = 
			array(
				array(
					'taxonomy' => 'gcategory',
					'field'    => 'slug',
					'terms'    => $current_tax,
				),
			);
	} else {
		$tax = '';
	}

	$query_args = array(
		'post_type' => 'gallery_cpt',
		'tax_query' => $tax,
		'posts_per_page' => 16,
		'meta_query' => array(
			array(
				'key' => 'gallery_image',
				'compare' => '!=',
				'value' => '',
			),
		),
		'paged' => $paged
	);
	$the_query = new WP_Query( $query_args );

	$gallery_imgs = '';
	if ( $the_query->have_posts() ) :
		while ( $the_query->have_posts() ) :  $the_query->the_post();
			if ( $i > 8  ) {$gallery_imgs .= '</div><!-- .row --></div><!-- .gallery --><div class="gallery"><div class="row">';}
			if( $i > 8 ) {$i = 1;}
			if ( ($i==3) || ($i==7) ) {$gallery_imgs .= '</div><div class="row">';}
			if( ($i == 1) || ($i == 2) ) {$grid = 'grid_6';}
			if( ($i == 3) || ($i == 4) || ($i == 8) ) {$grid = 'grid_3';}
			if( $i == 5 ) {$grid = 'grid_2';}
			if( $i == 6 ) {$grid = 'grid_4';}
			if( $i == 7 ) {$grid = 'offset_3 grid_6';}
			$thumb = '';
			if( get_field('gallery_image') ) {
				$thumb = '
					<div class="'. $grid .' t-grid-'. $i .'">
						<a href="'. get_field('gallery_image')['sizes']['large'] .'" data-lightbox="images" class="thumb blue thumb-'. $i .'" '. get_bg('gallery_image', 'medium') .'>
							<div class="table">
								<div class="cell">
									<p class="title">'. get_the_title() .'</p>
								</div>
							</div>
						</a>
					</div>';
				$i++;
			}
			$gallery_imgs .= $thumb;

			wp_reset_postdata();
		endwhile;
	endif; ?>
	
			<div class="pagecontent">
				<section id="hero" <?php echo get_bg_w_pid('hero_background', 316, 'heroBG'); ?> class="bg-section blue">
					<div class="overlay">
						<div class="row">
							<div class="grid_12">
								<h3 class="border"><span>Gallery</span></h3>
							</div>
						</div>
					</div>
				</section>

				<section id="categories">
					<div class="row">
						<div class="grid_12">
							<ul>
								<?php 
									$args = array('title_li' =>'', 'taxonomy' => 'gcategory');
									wp_list_categories( $args ); 
								 ?>
							</ul>
						</div>
					</div>
					<div class="row"><div class="grid_12"><div class="separator"></div></div></div>
				</section>
				
				<section id="gallery-ajax">
					<div id="gallery-wrapper" style="opacity: 0;">
						<div class="gallery">
							<div class="row">
								<?php echo $gallery_imgs; ?>
							</div>
						</div>

						<?php if ($the_query->max_num_pages > 1) { ?>
						<div class="row">
							<div class="grid_12">
								<div class="pagination">
									<?php echo get_next_posts_link( 'See More', $the_query->max_num_pages ); ?>
									<?php echo get_previous_posts_link( 'Go Back' ); ?>
								</div>
							</div>
						</div>
						<?php } ?>
		
					</div>
				</section>
				
			</div><!-- pagecontent -->
<?php get_footer(); ?>