<?php get_header(); ?>


<?php get_template_part( 'inc/pageheader' ); ?>

			<div class="pagecontent">

				<section id="hero" <?php echo get_parallax_bg('hero_background', 'heroBG'); ?> class="bg-section blue">
					<div class="overlay">
						<div class="logo-wrapper"><img src="<?php echo get_stylesheet_directory_uri(); ?>/img/logo.png" id="logo" alt="<?php bloginfo( 'name' ); ?>" /></div>
						<div class="scroll"><span>Scroll</span><span>Down</span></div>
					</div>
					<?php get_template_part( 'inc/nav' ); ?>
				</section>

				<section id="info1">
					<div class="row">
						<div class="grid_10 offset_1">
							<?php if( get_field('info1_headline') ) { ?>
								<h2><?php the_field('info1_headline') ?></h2>
							<?php } ?>
							<img src="<?php echo get_stylesheet_directory_uri(); ?>/img/i1-logo.png" class="i1-logo" alt="<?php bloginfo( 'name' ); ?>" />
							<?php if( get_field('info1_text') ) { ?>
								<p><?php the_field('info1_text') ?></p>
							<?php } ?>
						</div>
					</div>
				</section>

				<section id="info2" <?php echo get_parallax_bg('info2_background'); ?> class="bg bg-section blue">
					<div class="overlay">
						<div class="row">
							<div class="grid_10">
								<?php if( get_field('info2_headline') ) { ?>
									<h3 class="border"><span><?php the_field('info2_headline') ?></span></h3>
								<?php } ?>
								<?php if( get_field('info2_text') ) { ?>
									<p><?php the_field('info2_text') ?></p>
								<?php } ?>
								<?php if( get_field('info2_button_text') ) { ?>
									<h3 class="border"><a href="<?php the_field('info2_button_url') ?>"><?php the_field('info2_button_text') ?></a></h3>
								<?php } ?>
							</div>
						</div>
					</div>
				</section>

				<section id="info3" class="map">
						<div class="table">
							<div class="cell">
								<div class="row">
									<div class="grid_4">
										<?php echo get_img('info3_img', 'medium', 'i3-img'); ?>
									</div>
									<div class="grid_8">
										<?php if( get_field('info3_headline') ) { ?>
											<h3 class="border"><span><?php the_field('info3_headline') ?></span></h3>
										<?php } ?>
										<?php if( get_field('info3_text') ) { ?>
											<p><?php the_field('info3_text') ?></p>
										<?php } ?>
										<?php if( get_field('info3_button_text') ) { ?>
											<h3 class="border"><a href="<?php the_field('info3_button_url') ?>"><?php the_field('info3_button_text') ?></a></h3>
										<?php } ?>
									</div>
								</div>
							</div>
						</div>
				</section>

				<section id="info4" <?php echo get_parallax_bg('info4_background'); ?> class="bg bg-section yellow">
					<div class="overlay">
						<div class="row">
							<div class="grid_12">
								<?php if( get_field('info4_headline') ) { ?>
									<h3 class="border"><span><?php the_field('info4_headline') ?></span></h3>
								<?php } ?>
							</div>
						</div>
						<div class="row">
							<div class="grid_12">
<?php
	if( have_rows('info4_buttons') ):
		while ( have_rows('info4_buttons') ) : the_row();
								echo get_sub_btn_internal_external2('button_url_type', 'internal_page_link', 'external_page_link', 'button_text', 'testclass');	
		endwhile;
	endif;
?>			
							</div>
						</div>
					</div>
				</section>

				<section id="blog" class="map">
						<div class="table">
							<div class="cell">
								<div class="row">
									<div class="grid_12">
										<?php if( get_field('blog_headline') ) { ?>
											<h3 class="border"><span><?php the_field('blog_headline') ?></span></h3>
										<?php } ?>
									</div>
								</div>
								<div class="row">
<?php 
	$args = array( 'showposts' => '3', 'post_type' => 'post' );
	$the_query = new WP_Query( $args );
	if ( $the_query->have_posts() ) {
		while ( $the_query->have_posts() ) {
			$the_query->the_post();
?>
									<div class="grid_4">
										<?php if( get_the_title() ) { ?>
											<h4><a href="<?php the_permalink(); ?>"><?php the_title() ?></a></h4>
										<?php } ?>
										<h5><?php the_time('F jS, Y') ?></h5>
										<?php if( get_the_content() ) {
											echo '<p>'. trim_strip_content(get_the_content(), 200, '[...]') .'</p>';
										} ?>
									</div>
<?php
		}
	} else {
		echo 'No posts found.';
	}
	wp_reset_postdata();
?>
								</div>
								<div class="row">
									<div class="grid_12">
										<h3 class="border"><a href="/news">MORE NEWS &amp; EVENTS</a></h3>
									</div>
								</div>
							</div>
						</div>	
				</section>

			</div> <!-- .pagecontent -->

<?php get_footer(); ?>