<?php


/********** OPTIONS **********/

	$GLOBALS['mobile'] = true;				// Activate mobile
	$GLOBALS['default_bg_color'] = '#07476e';	// Background color if background image is empty

/*****************************/



/***** SITE SETUP *****/
if ( ! function_exists( 'apollo_setup' ) ) :
	function apollo_setup() {

		// Let WordPress manage the document title
		add_theme_support( 'title-tag' );

		// Enable support for Post Thumbnails on posts and pages
		add_theme_support( 'post-thumbnails' );

		// Switch default core markup for search form, comment form, and comments to output valid HTML5
		add_theme_support( 'html5', array( 'search-form', 'comment-form', 'comment-list', 'gallery', 'caption' ) );

		// Register menu locations
		register_nav_menus( array( 'main' => __( 'Main Menu', 'apollo' ) ) );

	}
endif;
add_action( 'after_setup_theme', 'apollo_setup' );


/***** DISABLE WP AUTO-UPDATES *****/
define( 'WP_AUTO_UPDATE_CORE', false );


/***** REMOVE WP VERSION NUMBER (THE GENERATOR) FROM <HEAD> *****/
remove_action( 'wp_head', 'wp_generator' );


/***** ENQUE SCRIPTS AND STYLES *****/
function apollo_scripts() {

	// Load Fonts.com
	wp_enqueue_style('fontscom-styles', 'http://fast.fonts.net/cssapi/b2050e74-646f-42ce-ab34-c725d00e22ac.css"', '', null );

	// Load Font Awesome
	wp_enqueue_style('fontawesome-styles', '//maxcdn.bootstrapcdn.com/font-awesome/4.3.0/css/font-awesome.min.css', '', null );

	// Load our main stylesheet
	wp_enqueue_style( 'apollo-style', get_stylesheet_uri() );




	// Load our main javascript file
	wp_enqueue_script( 'apollo-scripts', get_template_directory_uri() . '/js/scripts.js', array( 'jquery' ), '1.0' );

	// Load parallax file
	wp_enqueue_script( 'parallax-scripts', get_template_directory_uri() . '/js/parallax.min.js', array( 'jquery' ), '1.3.1' );

	// Load lightbox stylesheet and js
	if( is_archive('gallery_cpt') ) {
		wp_enqueue_style('lightbox-styles', get_template_directory_uri() . '/css/lightbox.css', '', '2.8.1' );
		wp_enqueue_script( 'lightbox-scripts', get_template_directory_uri() . '/js/lightbox.js', array( 'jquery' ), '2.8.1', true );
	}

	// Load google-map-scripts
	if( is_page_template('tmpl-contact.php') ) {
		// wp_enqueue_script( 'google-map-scripts', 'https://maps.googleapis.com/maps/api/js', array( 'jquery' ), '1', false );
	}

}
add_action( 'wp_enqueue_scripts', 'apollo_scripts' );


/***** TEMPLATE TAGS *****/


/***** CREATE ACF OPTIONS PAGE *****/
if ( function_exists( 'acf_add_options_page' ) ) :
	acf_add_options_page();
endif;


/***** CHANGE YOAST META BOX PRIORITY *****/
add_filter( 'wpseo_metabox_prio', function() {return 'low';} );


/***** REORDER ADMIN MENU - http://randyhoyt.com/wordpress/admin/ *****/
if ( ! function_exists( 'rrh_change_post_links' ) ) :
	function rrh_change_post_links() {
		global $menu;
		$menu[1000] = $menu[5]; // Copy posts into 1000
		$menu[5] = $menu[20]; // Copy pages into 5
		$menu[20] = $menu[25]; // Copy comments into 20
		$menu[25] = $menu[10]; // Copy media into 25
		$menu[10] = $menu[1000]; // Copy posts into 10
		unset($menu[1000]); // Kill 1000
		/*echo '<pre>';
		print_r($menu);
		echo '</pre>';*/
	}
endif;
add_action('admin_menu', 'rrh_change_post_links');


/***** REMOVING EMOJIS *****/
remove_action( 'wp_head', 'print_emoji_detection_script', 7 );
remove_action( 'wp_print_styles', 'print_emoji_styles' );


/***** CUSTOM IMAGE SIZES *****/
add_action( 'after_setup_theme', 'custom_images' );
function custom_images() {
	add_image_size( 'heroBG', 1920, 9999 );
}


/***** CUSTOM EXCERPTS *****/

	// Custom length
	if ( ! function_exists( 'new_excerpt_length' ) ) :
		function new_excerpt_length($length) {
			return 30;
		}
	endif;
	add_filter('excerpt_length', 'new_excerpt_length', 999);

	// Custom "more"
	if ( ! function_exists( 'new_excerpt_more' ) ) :
		function new_excerpt_more($more) {
			return '...';
		}
	endif;
	add_filter('excerpt_more', 'new_excerpt_more');

	function gallery_cpt_page( $query ) {
		if ( $query->is_post_type_archive('gallery_cpt') && $query->is_main_query() ) {
			$query->set( 'posts_per_page', 16 );
		}
	}

	function gallery_tax_page( $query ) { //NOT WORKING SO SWITCHED TO wp query on tax page
		if ( $query->is_tax() && $query->is_main_query() ) {

			global $wp_query;
			$args = array_merge( $wp_query->query, array( 'post_type' => 'gallery_cpt' ) );
			query_posts( $args );

			$query->set( 'posts_per_page', 2 );
		}
	}

/***** FUNCTIONS *****/
	//get image html tag, with src included
	function get_img($img, $size = 'medium', $class = null) {
		$class = ($class ? 'class="'. $class .'"' : '');
		$img = ( get_field($img) ? '<img '. $class .' src="'. get_field($img)['sizes'][$size] . '" alt="image" />' : '');
		return $img;
	}
	//get repeater image html tag, with src included
	function get_sub_img($img, $size = 'medium', $class = null) {
		$class = ($class ? 'class="'. $class .'"' : '');
		$img = ( get_sub_field($img) ? '<img '. $class .' src="'. get_sub_field($img)['sizes'][$size] . '" alt="image" />' : '');
		return $img;
	}
	//get data-parallax for parallax.min.js script
	function get_parallax_bg($bg_img, $size = 'large') {
		$bg_img = ( get_field($bg_img) ? 'data-parallax="scroll" data-image-src="'. get_field($bg_img)['sizes'][$size] .'"' : '');
		return $bg_img;
	}
	//get style="background-img..." background image
	function get_bg($bg_img, $size = 'large') {
		$bg_img = ( get_field($bg_img) ? 'style="background-image: url('. get_field($bg_img)['sizes'][$size] . ')"' : '');
		return $bg_img;
	}
	//get style="background-img..." background image, using post_ID.  For getting acf image on different page.
	function get_bg_w_pid($bg_img, $post_id, $size = 'large') {
		$bg_img = ( get_field($bg_img, $post_id) ? 'style="background-image: url('. get_field($bg_img, $post_id)['sizes'][$size] . ')"' : '');
		return $bg_img;
	}
	//get style="background-img..." repeater background image
	function get_sub_bg($bg_img, $size = 'large') {
		$bg_img = ( get_sub_field($bg_img) ? 'style="background-image: url('. get_sub_field($bg_img)['sizes'][$size] . ')"' : '');
		return $bg_img;
	}
	//get repeater data-parallax for parallax.min.js script
	function get_sub_parallax_bg($bg_img, $size = 'large') {
		$bg_img = ( get_sub_field($bg_img) ? 'data-parallax="scroll" data-image-src="'. get_sub_field($bg_img)['sizes'][$size] .'"' : '');
		return $bg_img;
	}
	//get featured image as style="background-image..."
	function get_featured_bg($the_post, $size = 'large') {
		if ( has_post_thumbnail($the_post) ) {
			$bg_img = wp_get_attachment_image_src( get_post_thumbnail_id( $the_post ), $size );
			$bg_img = 'style="background-image: url('. $bg_img[0] .')"';
			return $bg_img;
		}
	}
	//strip string of html, and limit ammount of characters
	function trim_strip_content($content, $limit, $see_more_text) {
		$content = strip_tags($content);
		$content = substr($content, 0, $limit);
		$content .= ' <a href="'. get_the_permalink() .'">'. $see_more_text .'</a>';
		return $content;
	}
	//get repeater button that is external or internal.  Includes surrounding div tag.
	//For future projects, use get_sub_btn_internal_external2.  This one is less awesome.
	function get_sub_btn_internal_external($activator, $internal, $external, $btn_text, $class = 'btn') {
		if ( get_sub_field($activator) == 'external' ) {
			$target = 'target="_blank"';
			$btn_url = ( (get_sub_field($external)) ? get_sub_field($external) :  '');
		} else {
			$target = '';
			$btn_url = ( (get_sub_field($internal)) ? get_sub_field($internal) :  '');
		}
		$sidebar_button = '<div class="btn border"><a '. $target .' href="'. $btn_url .'">'. get_sub_field($btn_text) .'</a></div>'; //class should be a variable.
		return $sidebar_button;
	}
	//get repeater button that is external or internal.  This one only returns anchor tag.
	function get_sub_btn_internal_external2($activator, $internal, $external, $btn_text, $class = 'btn') {
		if( get_sub_field($activator) == 'external' ) {
			$btn_url = ( (get_sub_field($external)) ? get_sub_field($external) :  false);
			$target = 'target="_blank"';
		} else {
			$btn_url = ( (get_sub_field($internal)) ? get_sub_field($internal) :  false);
			$target = '';
		}
		$btn_text = ( (get_sub_field($btn_text)) ? get_sub_field($btn_text) :  false);
		if ($btn_url && $btn_text) {
			$class = ( $class ? 'class="'. $class .'"' : '');
			$sidebar_button = '<a '. $class .' '. $target .' href="'. $btn_url .'">'. $btn_text .'</a>';
		} else {
			$sidebar_button = '';
		}
		return $sidebar_button;
	}


?>