<?php get_header(); ?>

<?php get_template_part( 'inc/pageheader' ); ?>

			<div class="pagecontent">

				<section id="hero" <?php echo get_bg_w_pid('hero_background', get_option('page_for_posts'),'heroBG'); ?> class="bg-section blue">
					<div class="overlay">
						<div class="row">
							<div class="grid_12">
								<h3 class="border"><span>News</span></h3>
							</div>
						</div>
					</div>
				</section>

				<section id="categories">
					<div class="row">
						<div class="grid_7">
							<ul>
								<?php wp_list_categories('title_li='); ?> 
							</ul>
						</div>
						<div class="grid_5">
							<?php get_search_form( true ); ?>
						</div>
					</div>
					<div class="row"><div class="grid_12"><div class="separator"></div></div></div>
				</section>

				<section id="news">
<?php
	if ( have_posts() ) :
		while ( have_posts() ) : the_post();
		$bg_img = (get_field(''));

?>
					<div class="row">
						<div class="grid_5">
							<div class="bg-img" <?php echo get_featured_bg( get_the_ID(), 'small'); ?>></div>
						</div>
						<div class="grid_7">
							<h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
							<h5><?php the_time( 'F j, Y' ) ?></h5>
							<p><?php echo trim_strip_content( get_the_content(), 430, '...' ); ?></p>
							<p class="readmore"><a href="<?php the_permalink(); ?>">Read More <i class="fa fa-angle-double-right"></i></a></p>
						</div>
					</div>
<?php
		endwhile;
	else :

		echo
			'<div class="row">
				<div class="grid_12">
					We\'re sorry, but the page you\'re looking for isn\'t available.
				</div>				
			</div>';
	endif;
?>			
				</section>
				<div class="row">
					<div class="grid_12">
						<div class="pagination">
							<?php next_posts_link( 'Older posts' ); ?>
							<?php previous_posts_link( 'Newer posts' ); ?>
						</div>
					</div>
				</div>

			</div> <!-- .pagecontent -->

<?php get_footer(); ?>