<?php
if (get_field('hero_background')) {
	$bg = get_field('hero_background');
	$background = 'data-parallax="scroll" data-image-src="' . $bg['sizes']['heroBG'] . '"';
} else {
	$background = 'style="background-color: #07476e;"';
}
?>
<section id="hero" <?php echo $background; ?>>
	<div class="overlay">
		<div class="logo-wrapper"><img src="<?php echo get_stylesheet_directory_uri(); ?>/img/logo.png" id="logo" alt="<?php bloginfo( 'name' ); ?>" /></div>
		<div class="scroll"><span>Scroll</span><span>Down</span></div>
	</div>
</section>

<section id="info1">
	<img src="<?php echo get_stylesheet_directory_uri(); ?>/img/map.png" alt="" class="diamond map" />
	<img src="<?php echo get_stylesheet_directory_uri(); ?>/img/diamond-small1.png" alt="" class="diamond small1" />
	<img src="<?php echo get_stylesheet_directory_uri(); ?>/img/diamond-large1.png" alt="" class="diamond large1" />
	<div class="row">
		<div class="grid_4">
			<?php if (get_field('contact_address', 'options') || get_field('contact_city', 'options') || get_field('contact_state', 'options') || get_field('contact_zip', 'options')) { ?>
			<h3><span>Our Location</span></h3>
			<p>
			<?php if (get_field('contact_address', 'options')) {the_field('contact_address', 'options');} ?>
			<?php if (get_field('contact_address', 'options') && (get_field('contact_city', 'options') || get_field('contact_state', 'options') || get_field('contact_zip', 'options'))) {echo '<br />';} ?>
			<?php if (get_field('contact_city', 'options')) {the_field('contact_city', 'options');} ?>
			<?php if (get_field('contact_city', 'options') && get_field('contact_state', 'options')) {echo ', ';} ?>
			<?php if (get_field('contact_state', 'options')) {the_field('contact_state', 'options');} ?>
			<?php if (get_field('contact_state', 'options') && get_field('contact_zip', 'options')) {echo ' ';} ?>
			<?php if (get_field('contact_zip', 'options')) {the_field('contact_zip', 'options');} ?>
			</p>
			<?php } ?>
		</div>
		<div class="grid_4 offset_4">
			<?php if (get_field('contact_phone', 'options') || get_field('contact_fax', 'options') || get_field('contact_email', 'options')) { ?>
			<h3><span>Contact Us</span></h3>
			<p>
			<?php if (get_field('contact_phone', 'options')) {echo '<span class="top phone"><strong>P<span>hone</span>: </strong>' . get_field('contact_phone', 'options') . '</span>';} ?>
			<?php if (get_field('contact_fax', 'options')) {echo '<span class="top fax"><strong>F<span>ax</span>: </strong>' . get_field('contact_fax', 'options') . '</span>';} ?>
			<?php if (get_field('contact_email', 'options')) {echo '<span class="top email"><strong>E<span>mail</span>: </strong><a href="mailto:' . antispambot(get_field('contact_email', 'options')) . '">' . antispambot(get_field('contact_email', 'options')) . '</a></span>';} ?>
			<?php if (get_field('rate_sheet', 'options')) {echo '<span class="top rates"><strong>New rate sheet: </strong><a href="' . get_field('rate_sheet', 'options') . '" target="_blank">View rates</a></span>';} ?>
			</p>
			<?php } ?>
		</div>
	</div>
	<?php if (get_field('info1_headline') || get_field('info1_content')) { ?>
	<div class="row">
		<div class="grid_4 offset_8">
			<?php if (get_field('info1_headline')) { ?><h3><span><?php the_field('info1_headline'); ?></span></h3><?php } ?>
			<?php if (get_field('info1_content')) { ?><p><?php the_field('info1_content'); ?></p><?php } ?>
		</div>
	</div>
	<?php } ?>
</section>

<?php
if (get_field('info2_background')) {
	$bg = get_field('info2_background');
	$background = 'data-parallax="scroll" data-image-src="' . $bg['sizes']['heroBG'] . '"';
} else {
	$background = 'style="background-color: #07476e;"';
}
?>
<section id="info2" <?php echo $background; ?>>
	<div class="inner">
		<div class="row">
			<div class="grid_7">
				<?php if (get_field('info2_headline')) { ?><h3><span><?php the_field('info2_headline'); ?></span></h3><?php } ?>
				<?php if (get_field('info2_content')) { ?><p><?php the_field('info2_content'); ?></p><?php } ?>
<?php
$rows = get_field('info2_list');
if ($rows) {
?>
				<ul>
<?php
	foreach ($rows as $row) {
?>
					<li><?php echo $row['list_item']; ?></li>
<?php
	}
?>
				</ul>
<?php
}
?>
			</div>
		</div>
	</div>
</section>

<?php
$the_query = new WP_Query(array(
	'post_type' => 'post',
	'posts_per_page' => 2
));

if ( $the_query->have_posts() ) {
	$blogs = array();
	$i = 1;
?>
<section id="blog">
	<img src="<?php echo get_stylesheet_directory_uri(); ?>/img/diamond-small2.png" alt="" class="diamond small2" />
	<img src="<?php echo get_stylesheet_directory_uri(); ?>/img/diamond-large2.png" alt="" class="diamond large2" />
	<img src="<?php echo get_stylesheet_directory_uri(); ?>/img/diamond-small3.png" alt="" class="diamond small3" />
	<div class="table">
		<div class="cell">
			<div class="row">
				<div class="grid_6 offset_6">
					<h3><span>From Our Blog</span></h3>
				</div>
			</div>
<?php
	while ( $the_query->have_posts() ) {
		$the_query->the_post();
		$blogs[$i] = array(
			'title' => get_the_title(),
			'date' => get_the_date(),
			'content' => get_the_content(),
		);
?>
			<div class="row blog-post">
				<div class="grid_1 offset_6">
					<span class="month"><?php echo get_the_date('M'); ?></span>
					<span class="day"><?php echo get_the_date('j'); ?></span>
				</div>
				<div class="grid_5">
					<h4><a href="#<?php //echo $post->post_name; ?>"><?php the_title(); ?></a></h4>
					<div class="excerpt"><?php the_excerpt(); ?></div>
					<p class="more"><a href="#<?php //echo $post->post_name; ?>">Read more <i class="fa fa-angle-right"></i></a></p>
					<div class="flyout">
						<a href="#" class="close">Close <i class="fa fa-angle-right"></i></a>
						<div class="date"><?php echo get_the_date(); ?></div>
						<div class="content">
							<div class="inner">
								<h4 class="innerTitle"><?php the_title(); ?></h4>
								<?php the_content(); ?>
								<p class="hide"><a href="#">Read less <i class="fa fa-angle-up"></i></a></p>
							</div>
						</div>
					</div>
				</div>
			</div>
<?php
		$i++;
	}
?>
		</div>
	</div>
</section>

<script>
jQuery(function() {
	var winWidth = jQuery(window).width();
	
	jQuery('.blog-post .more a').click(function(e) {
		e.preventDefault();
		jQuery(this).parent().next().addClass('open');
	});
	jQuery('.blog-post h4 a').click(function(e) {
		e.preventDefault();
		jQuery(this).parent().next().next().next().addClass('open');
	});
	jQuery('.blog-post .close').click(function(e) {
		e.preventDefault();
		jQuery('.flyout').each(function() {
			jQuery(this).removeClass('open');
		});
	});

	if (winWidth < 768) {
		jQuery('.blog-post .more a').click(function(e) {
			e.preventDefault();
			jQuery(this).parent().prev().hide();
			jQuery(this).parent().hide();
		});
		jQuery('.blog-post h4 a').click(function(e) {
			e.preventDefault();
			jQuery(this).parent().next().hide();
			jQuery(this).parent().next().next().hide();
		});
		jQuery('.blog-post .hide a').click(function(e) {
			e.preventDefault();
			jQuery(this).parent().parent().parent().parent().removeClass('open');
			jQuery(this).parent().parent().parent().parent().prev().show();
			jQuery(this).parent().parent().parent().parent().prev().prev().show();
			//jQuery('#hero').css('height', '100vh');
		});
	}
});
</script>

<?php
}

wp_reset_postdata();
?>