<?php
/*
Template Name: Contact Template
*/
?>
<?php get_header(); ?>


<?php get_template_part( 'inc/pageheader' ); ?>
	
			<div class="pagecontent">

				<section id="hero" <?php echo get_bg_w_pid('hero_background', 316, 'heroBG'); ?> class="bg-section blue">
					<div class="overlay">
						<div class="row">
							<div class="grid_12">
								<h3 class="border"><span><?php the_title() ?></span></h3>
							</div>
						</div>
					</div>
				</section>

				<section id="contact-info1" class="contact-info">
					<div class="row">
						<?php
							$grid = 0;
							if( get_field('contact_address', 'options') || get_field('contact_city', 'options') || get_field('contact_state', 'options') || get_field('contact_zip', 'options') ) { $grid++; }
							if( get_field('contact_phone', 'options') ) { $grid++; }
							if( get_field('contact_fax', 'options') ) { $grid++; }
							if( get_field('contact_email', 'options') ) { $grid++; }
							$grid = 12 / $grid;
							$grid = 'grid_'. $grid;
						?>
						<?php if( get_field('contact_address', 'options') || get_field('contact_city', 'options') || get_field('contact_state', 'options') || get_field('contact_zip', 'options') ) { ?>
							<div class="<?php echo $grid; ?>">
								<div class="inner">
									<i class="ico fa fa-map-marker"></i>

									<h4>Address</h4>
									<p>
									<?php if( get_field('contact_address', 'options') ) { ?>
										<?php the_field('contact_address', 'options') ?><br />
									<?php } ?>
									<?php if( get_field('contact_city', 'options') ) { ?>
										<?php the_field('contact_city', 'options') ?><br />
									<?php } ?>
									<?php if( get_field('contact_state', 'options') ) { ?>
										<?php the_field('contact_state', 'options') ?>
									<?php } ?>
									<?php if( get_field('contact_zip', 'options') ) { ?>
										<?php the_field('contact_zip', 'options') ?>
									<?php } ?>
									</p>
								</div>
							</div>
						<?php } ?>

						<?php if( get_field('contact_phone', 'options') ) { ?>
							<div class="<?php echo $grid; ?>">
								<div class="inner">
									<i class="ico fa fa-phone"></i>

									<h4>Phone</h4>
									<p><?php the_field('contact_phone', 'options') ?></p>
								</div>
							</div>
						<?php } ?>

						<?php if( get_field('contact_fax', 'options') ) { ?>
							<div class="<?php echo $grid; ?>">
								<div class="inner">
									<i class="ico fa fa-print"></i>

									<h4>Fax</h4>
									<p><?php the_field('contact_fax', 'options') ?></p>
								</div>
							</div>
						<?php } ?>

						<?php if( get_field('contact_email', 'options') ) { ?>
							<div class="<?php echo $grid; ?> hover">
								<div class="inner">
									<a href="mailto:<?php echo antispambot( get_field('contact_email', 'options') ); ?>"><i class="ico fa fa-envelope"></i></a>

									<h4>Email</h4>
									<p>
										<a class="email" href="mailto:<?php echo antispambot( get_field('contact_email', 'options') ); ?>">
											<?php echo antispambot( get_field('contact_email', 'options') ); ?>
										</a>
									</p>
								</div>
							</div>
						<?php } ?>
					</div>
				</section>
				<div class="row"><div class="grid_12"><div class="separator"></div></div></div>
				<section id="contact-info2" class="contact-info">
					<div class="row">
						<?php
							$grid = 0;
							if( get_field('pga_dock_master_name', 'options') ) { $grid++; }
							if( get_field('pga_office_manager_name', 'options') ) { $grid++; }
							// if( get_field('amh_street_address', 'options') || get_field('amh_city', 'options') || get_field('amh_state', 'options') || get_field('amh_zip_code', 'options') || get_field('amh_phone_number', 'options') ) { $grid++; }

							if( get_field('senior_dock_master_name', 'options') ) { $grid++; }

							if( get_field('amh_street_address', 'options') || get_field('amh_city', 'options') || get_field('amh_state', 'options') || get_field('amh_zip_code', 'options') ) {
								$address = true;
							}
							if( $address || get_field('amh_phone_number', 'options') ) { $grid++; }

							$grid = 12 / $grid;
							$grid = 'grid_'. $grid;
						?>
						<?php if( get_field('pga_dock_master_name', 'options') ) { ?>
							<div class="grid_3 hover ">
								<div class="inner">
									<a href="mailto:<?php echo antispambot( get_field('pga_dock_master_email_address', 'options') ); ?>"><i class="ico fa fa-user"></i></a>
									<h4>PGA dockmaster</h4>
									<h5><?php the_field('pga_dock_master_name', 'options') ?></h5>
									<?php if( get_field('pga_dock_master_title', 'options') ) { ?>
										<h6><?php the_field('pga_dock_master_title', 'options') ?></h6>
									<?php } ?>
									<p>
										<a class="email" href="mailto:<?php echo antispambot( get_field('pga_dock_master_email_address', 'options') ); ?>">
											<?php echo antispambot( get_field('pga_dock_master_email_address', 'options') ); ?>
										</a>
									</p>
								</div>
							</div>
						<?php } ?>

						<?php if( get_field('pga_office_manager_name', 'options') ) { ?>
							<div class="grid_3 hover ">
								<div class="inner">
									<a href="mailto:<?php echo antispambot( get_field('pga_office_manager_email_address', 'options') ); ?>"><i class="ico fa fa-user"></i></a>
									<h4>PGA Office manager</h4>
									<h5><?php the_field('pga_office_manager_name', 'options') ?></h5>
									<?php if( get_field('pga_office_manager_title', 'options') ) { ?>
										<h6><?php the_field('pga_office_manager_title', 'options') ?></h6>
									<?php } ?>
									<p>
										<a class="email" href="mailto:<?php echo antispambot( get_field('pga_office_manager_email_address', 'options') ); ?>">
											<?php echo antispambot( get_field('pga_office_manager_email_address', 'options') ); ?>
										</a>
									</p>
								</div>
							</div>
						<?php } ?>

						<?php if( $address || get_field('amh_phone_number', 'options') ) { ?>
							<div class="grid_3">
								<div class="inner">
									<i class="ico fa fa-user"></i>
									<h4>Marina Management</h4>
									<p>amh management</p>
									<?php if($address) { ?>
										<p>
											<?php if( get_field('amh_street_address', 'options') ) { ?>
												<?php the_field('amh_street_address', 'options') ?><br />
											<?php } ?>
											<?php if( get_field('amh_city', 'options') ) { ?>
												<?php the_field('amh_city', 'options') ?><br />
											<?php } ?>
											<?php if( get_field('amh_state', 'options') ) { ?>
												<?php the_field('amh_state', 'options') ?>
											<?php } ?>
											<?php if( get_field('amh_zip_code', 'options') ) { ?>
												<?php the_field('amh_zip_code', 'options') ?><br />
											<?php } ?>
											<?php if( get_field('amh_phone_number', 'options') ) { ?>
												<?php the_field('amh_phone_number', 'options') ?>
											<?php } ?>
										</p>
									<?php } ?>

								</div>
							</div>
						<?php } ?>

						<?php if( get_field('senior_dock_master_name', 'options') ) { ?>
							<div class="grid_3 hover ">
								<div class="inner">
									<a href="mailto:<?php echo antispambot( get_field('senior_dock_master_email_address', 'options') ); ?>"><i class="ico fa fa-user"></i></a>
									<h4>senior dockmaster</h4>
									<h5><?php the_field('senior_dock_master_name', 'options') ?></h5>
									<?php if( get_field('senior_dock_master_title', 'options') ) { ?>
										<h6><?php the_field('senior_dock_master_title', 'options') ?></h6>
									<?php } ?>
									<p>
										<a class="email" href="mailto:<?php echo antispambot( get_field('senior_dock_master_email_address', 'options') ); ?>">
											<?php echo antispambot( get_field('senior_dock_master_email_address', 'options') ); ?>
										</a>
									</p>
								</div>
							</div>
						<?php } ?>
					</div>
				</section>

				<section id="form">
					<div class="row">
						<div class="grid_12">
							<h3>Leave a Message</h3>
						</div>
					</div>

					<div class="row">
						<?php gravity_form( 1, false, false, false, '', false ); ?>
					</div>
				</section>

				<section id="map">
					<div class="table">
						<div class="cell">
							<a target="_blank" href="https://www.google.com/maps/place/2385+PGA+Blvd,+Palm+Beach+Gardens,+FL+33410/@26.844922,-80.069604,17z/data=!3m1!4b1!4m2!3m1!1s0x88df2ac22539cda7:0x5bca457b9cd7f666!6m1!1e1"><img src="<?php echo get_stylesheet_directory_uri(); ?>/img/goog-map-pointer.png" class="i1-logo" alt="<?php bloginfo( 'name' ); ?>" /></a>
						</div>
					</div>
				</section>

			</div> <!-- .pagecontent -->

<?php get_footer(); ?>